<?php
     //Quelques fonctions utiles pour la gestion d'un calendrier
     
     //Transforme un numro de mois en son nom en franais
     function getMois($mois){
       $mois=sprintf("%d",$mois);
       $tab_mois=array(1=>"Janvier","Fvrier","Mars","Avril","Mai","Juin","Juillet","Aot","Septembre","Octobre","Novembre","Dcembre");
       return $tab_mois[$mois];
     }
     
     //fonction qui renvoit le mois et l'anne  dans le calendrier en fonction du pas
     //un pas de 1 signifie la date pour le mois suivant celui pass en paramtre
     //un pas de -1 signifie la date pour le mois prcdent celui pass en paramtre
     function getSuivant($mois,$annee,$pas){
       $tmstp_suivant=mktime(0,0,0,($mois+$pas),1,$annee);
       $date_suivante[mois]=date("m",$tmstp_suivant);
       $date_suivante[annee]=date("Y",$tmstp_suivant);
       return $date_suivante;
     }
     
     //fonction qui retourne le premier jour du mois
     //0->Lundi
     //1->Mardi
     //...
     //6->Dimanche
     function getFirstDay($mois,$annee){
       $tmstp=mktime(0,0,0,$mois,1,$annee);
       //on rcupre le numro du jour de la semaine... mais au format anglais (0->dimanche, ...) mais
       //nous on veut un calendrier commenant le lundi !!
       $jour=date("w",$tmstp);

       $tab_jour=array(0=>7,1=>1,2=>2,3=>3,4=>4,5=>5,6=>6);
       
       return $tab_jour[$jour];
     }
?>